//****************************************************************************************
// Name:		constants.h
// Platform:	SQL Server 2000 SP3a or higher, Windows NT, 2000 or XP
// Author:		Copyright (c) 2006 by Michael Coles, MCDBA
//
// Description:	Defines constants and messages used throughout the XP's
//
// LEGAL STUFF:
// ------------
// Copyright (C) 2005 - 2006 by Michael Coles, MCDBA
//
// Some included code included is released under the redistribution agreements as 
// specified by the authors of the respective code.  Copyright holders of this included 
// code maintain all copyright and other rights to their original or derivative works.
//
// All rights reserved.                          
//
// REDISTRIBUTION OF THIS CODE:
// ----------------------------
// All code included in this package is either the original work of the copyright holder,
// or derivative work based on other copyright holders' works.  All derivative works 
// include information as required by the copright holders' redistribution agreements.
// These redistribution agreements, where possible, are included in the text of the source
// code distributed with this code.
//
// Redistribution and use in source and binary forms, with or without modification, are 
// permitted provided that the following conditions are met:
//
//   1. Redistributions of source code must retain the above copyright notice, this list 
//      of conditions and the following disclaimer.
//
//   2. Redistributions in binary form must reproduce the above copyright notice, this 
//      list of conditions and the following disclaimer in the documentation and/or other 
//      materials provided with the distribution.
//
//   3. The names of its contributors may not be used to endorse or promote products 
//      derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY 
// WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//****************************************************************************************
#pragma once
#define		NOT_EXISTS					0
#define		EXISTS						1
#define		XP_NOERROR					0
#define		XP_ERROR					1
#define		MAX_SQL_LEN					512
#define		SRV_MAXERROR				20000
#define		GETTABLE_ERROR				SRV_MAXERROR + 1
#define		REMOTE_FAIL					4002
#define		REMOTE_MSG					SRV_MAXERROR + 3
#define		MAXLEN						256
#define		APP_NAME					"Scrypto"
#define		SCRYPTO_KEY_CONTAINER		"SCRYPTO"
#define		SQL_GET_KEYS				"EXEC dbo.sp_executesql N'SELECT m.[Key], l.[Key] FROM [master].[dbo].[Master_Key_Vault] m, [master].[dbo].[Local_Key_Vault] l WHERE l.[Master_Key_Name] = m.[Name] AND l.[Name] = @keyname;', N'@keyname VARCHAR(128)', @keyname = '%s'"
#define		ERR_KEY_NOT_FOUND			"ERROR:  Encryption key not found."
#define		ERR_CRYPTOAPI_CONTAINER		"ERROR:  Cannot acquire a CryptoAPI context."
#define		ERR_CRYPTOAPI_CREATEHASH	"ERROR:  Could not create a Crypto API Hash object."
#define		ERR_CRYPTOAPI_SHA1			"ERROR:  Could not create SHA1 hash using Crypto API."
#define		ERR_CRYPTOAPI_DERIVE_KEY	"ERROR:  Could not derive a key using Crypto API."
#define		ERR_CRYPTOAPI_DEC_MASTER	"ERROR:  Could not decrypt master key using Crypto API."
#define		ERR_KEY_LENGTH				"ERROR:  Key length was too short for encryption/decryption routines."
#define		ERR_OUTPUT_LENGTH			"ERROR:  Output parameter is too small to hold estimated output size."
#define		ERR_BAD_KEY_BITS			"ERROR:  Bit length specifier for keys not valid size for this algorithm."
#define		ERR_BAD_HASH_BITS			"ERROR:  Bit length specifier for hash not valid size for this algorithm."
#define		ERR_REGEX_EXCEPTION			"ERROR:  Error in regular expression procedure.  This can be caused by an invalid regular expression, \nor an expression that approaches O(N^2) complexity or runs out of stack space.\n"
#define		ERR_HASH_EXCEPTION			"ERROR:  Internal error during hash process."
#define		ERR_CRYPT_EXCEPTION			"ERROR:  Internal error during encryption or decryption process."
#define		ERR_ROT13_EXCEPTION			"ERROR:  Internal error during ROT13 enciphering."
#define		ERR_DIRSCAN_EXCEPTION		"ERROR:  Internal error during xp_dirscan process."
#define		ERR_PROPERCASE_EXCEPTION	"ERROR:  Internal error during xp_propercase."
#define		ERR_JARO_EXCEPTION			"ERROR:  Internal error during xp_dist_jaro."
#define		ERR_LEV_EXCEPTION			"ERROR:  Internal error during xp_dist_lev."
#define		ERR_DMETA_EXCEPTION			"ERROR:  Internal error during xp_phon_dmeta."
#define		ERR_NYSIIS_EXCEPTION		"ERROR:  Internal error during xp_phon_nysiis."
#define		ERR_CELKO_EXCEPTION			"ERROR:  Internal error during xp_phon_celko."
#define		ERR_DM_EXCEPTION			"ERROR:  Internal error during xp_phon_dm."
#define		USAGE_HASH_SHA				"USAGE:  EXEC xp_hash_sha @plaintext, @hashcode OUTPUT [, @bitcount]\n::First parameter is the plain text to hash.\n::Second parameter is the output parameter that holds the hash code.\n::The third parameter is the bit count.  A NULL value defaults to 512 bits."
#define		USAGE_REGEX_SEARCH			"USAGE:  EXEC xp_regex_search @regex, @text, @flags\n::First parameter is the regular expression.\n::Second parameter is the text to match against.\n::The third parameter contains flags that control match behavior.  Currently supported flags are G+ (show groups) and I+ (case insensitivity on).\n::Results are returned as a result set."
#define		USAGE_REGEX_MATCH			"USAGE:  EXEC xp_regex_match @regex, @text, @flags, @result OUTPUT\n::First parameter is the regular expression.\n::Second parameter is the text to match against.\n::The third parameter contains flags.  Currently supported flag is I+ (case insensitivity on).\n::The fourth parameter is the output - 'Y' for yes (match) or 'N' for no (no match)"
#define		USAGE_REGEX_REPLACE			"USAGE:  EXEC xp_regex_replace @regex, @text, @replacementtext, @flags, @result OUTPUT\n::First parameter is the regular expression.\n::Second parameter is the text to match against.\n::THe third parameter contains the replacement text.\n::The fourth parameter contains flags.  Currently supported flag is I+ (case insensitivity on).\n::The fifth parameter is the output of the procedure."
#define		USAGE_CREATE_MASTER_KEY		"USAGE:  EXEC xp_create_master_key @password, @masterkey OUTPUT [, @password2]\n::First parameter is a password (0 - 128 bytes).  Use NULL to generate a random key.\n::Second parameter is at least 64 bytes long; the 512-bit key is passed back in this parameter.\n::Third parameter is optional.  When used it is a second password used to encrypt the key."
#define		USAGE_CREATE_LOCAL_KEY		"USAGE:  EXEC xp_create_local_key @masterkey, @localkey OUTPUT [, @password]\n::First parameter is the master key.\n::Second parameter is at least 64 bytes long; the 512-bit key is passed back in this parameter.\n::Third parameter is optional.  When used it is the password previously used to encrypt the master key."
#define		USAGE_ENCRYPT_AES			"USAGE:  EXEC xp_encrypt_aes @plaintext, @encryptedtext OUTPUT, @password, @masterkey, @localkey, @keybits\n::First parameter is the plain text to encrypt.\n::Second parameter is the encrypted text OUTPUT parameter with the result of encryption.\n::Third parameter is the password used to previously encrypt the master key.  If NULL is passed in, the current logged in user info is used to decrypt the key.\n::Fourth parameter the encrypted master key.\n::The fifth parameter is the encrypted local key\n::The sixth parameter is the number of bits to use in the key (128, 192 or 256).  NULL defaults to 256."
#define		USAGE_DECRYPT_AES			"USAGE:  EXEC xp_decrypt_aes @encryptedtext, @plaintext OUTPUT, @password, @masterkey, @localkey, @keybits\n::First parameter is the encrypted text to decrypt.\n::Second parameter is plain text OUTPUT parameter with the result of decryption.\n::Third parameter is the password used to previously encrypt the master key.  If NULL is passed in, the current logged in user info is used to decrypt the key.\n::Fourth parameter is the encrypted master key.\n::The fifth parameter is the encrypted local key.\n::The sixth parameter is the number of bits to use in the key (128, 192 or 256).  NULL defaults to 256."
#define		USAGE_ENCRYPT_DES			"USAGE:  EXEC xp_encrypt_des @plaintext, @encryptedtext OUTPUT, @password, @masterkey, @localkey\n::First parameter is the plain text to encrypt.\n::Second parameter is the encrypted text OUTPUT parameter with the result of encryption.\n::Third parameter is the password used to previously encrypt the master key.  If NULL is passed in, the current logged in user info is used to decrypt the key.\n::Fourth parameter the encrypted master key.\n::The fifth parameter is the encrypted local key"
#define		USAGE_DECRYPT_DES			"USAGE:  EXEC xp_decrypt_des @encryptedtext, @plaintext OUTPUT, @password, @masterkey, @localkey\n::First parameter is the encrypted text to decrypt.\n::Second parameter is plain text OUTPUT parameter with the result of decryption.\n::Third parameter is the password used to previously encrypt the master key.  If NULL is passed in, the current logged in user info is used to decrypt the key.\n::Fourth parameter is the encrypted master key.\n::The fifth parameter is the encrypted local key."
#define		USAGE_ENCRYPT_3DES			"USAGE:  EXEC xp_encrypt_3des @plaintext, @encryptedtext OUTPUT, @password, @masterkey, @localkey\n::First parameter is the plain text to encrypt.\n::Second parameter is the encrypted text OUTPUT parameter with the result of encryption.\n::Third parameter is the password used to previously encrypt the master key.  If NULL is passed in, the current logged in user info is used to decrypt the key.\n::Fourth parameter the encrypted master key.\n::The fifth parameter is the encrypted local key."
#define		USAGE_DECRYPT_3DES			"USAGE:  EXEC xp_decrypt_3des @encryptedtext, @plaintext OUTPUT, @password, @masterkey, @localkey\n::First parameter is the encrypted text to decrypt.\n::Second parameter is plain text OUTPUT parameter with the result of decryption.\n::Third parameter is the password used to previously encrypt the master key.  If NULL is passed in, the current logged in user info is used to decrypt the key.\n::Fourth parameter is the encrypted master key.\n::The fifth parameter is the encrypted local key."
#define		USAGE_ENCRYPT_BLOWFISH		"USAGE:  EXEC xp_encrypt_blowfish @plaintext, @encryptedtext OUTPUT, @password, @masterkey, @localkey, @keybits\n::First parameter is the plain text to encrypt.\n::Second parameter is the encrypted text OUTPUT parameter with the result of encryption.\n::Third parameter is the password used to previously encrypt the master key.  If NULL is passed in, the current logged in user info is used to decrypt the key.\n::Fourth parameter the encrypted master key.\n::The fifth parameter is the encrypted local key\n::The sixth parameter is the number of bits to use in the key (32 to 448, multiple of 8)."
#define		USAGE_DECRYPT_BLOWFISH		"USAGE:  EXEC xp_decrypt_blowfish @encryptedtext, @plaintext OUTPUT, @password, @masterkey, @localkey, @keybits\n::First parameter is the encrypted text to decrypt.\n::Second parameter is plain text OUTPUT parameter with the result of decryption.\n::Third parameter is the password used to previously encrypt the master key.  If NULL is passed in, the current logged in user info is used to decrypt the key.\n::Fourth parameter is the encrypted master key.\n::The fifth parameter is the encrypted local key.\n::The sixth parameter is the number of bits to use in the key (32 to 448, multiple of 8)."
#define		USAGE_ROT13					"USAGE:  EXEC xp_rot13 @text, @output OUTPUT\n::Parameter one is the text to ROT13 encipher.\n::Parameter two is the output/enciphered text."
#define		USAGE_DOUBLE_META			"USAGE:  EXEC xp_phon_dmetaphone @word, @out1 OUTPUT, @out2 OUTPUT\n::The first parameter is the word/name to encode.\n::The second and third parameters are the double-metaphone results.\n"
#define		USAGE_DIRSCAN				"USAGE:  EXEC xp_dirscan @path, @filemask\n::First parameter is the path to begin directory scan.\n::Second parameter is the filename mask.  All sub-directories are returned, but only files with names matching this pattern are returned.\n"
#define		USAGE_PROPERCASE			"USAGE:  EXEC xp_propercase @instring, @outstring OUTPUT\n::First parameter is the string to proper case.\n::Second parameter is the proper-cased string.\n"
#define		USAGE_JARO					"USAGE:  EXEC xp_dist_jaro @string1, @string2, @distance OUTPUT, @options\n::First two parameters are the strings to compare.\n::Third parameter holds the result of the comparison.\n::The last parameter contains comparison options.\n"
#define		USAGE_LEV					"USAGE:  EXEC xp_dist_lev @string1, @string2, @distance OUTPUT\n::First two parameters are the string to compare.\n::Last parameter is the edit distance result.\n"
#define		USAGE_DMETA					"USAGE:  EXEC xp_phon_dmeta @string, @code1 OUTPUT, @code 2 OUTPUT\n::First parameter is the string to phonetically encode.\n::Last two parameters are the return result of encoding.\n"
#define		USAGE_NYSIIS				"USAGE:  EXEC xp_phon_nysiis @string, @code OUTPUT\n::Parameter 1 is the string to phonetically encode using NYSIIS.\n::Parameter 2 is the NYSIIS-encoded result.\n"
#define		USAGE_ENCRYPT_TWOFISH		"USAGE:  EXEC xp_encrypt_twofish @plaintext, @encryptedtext OUTPUT, @password, @masterkey, @localkey, @keybits\n::First parameter is the plain text to encrypt.\n::Second parameter is the encrypted text OUTPUT parameter with the result of encryption.\n::Third parameter is the password used to previously encrypt the master key.  If NULL is passed in, the current logged in user info is used to decrypt the key.\n::Fourth parameter the encrypted master key.\n::The fifth parameter is the encrypted local key\n::The sixth parameter is the number of bits to use in the key (128, 192 or 256).  NULL defaults to 256."
#define		USAGE_DECRYPT_TWOFISH		"USAGE:  EXEC xp_decrypt_twofish @encryptedtext, @plaintext OUTPUT, @password, @masterkey, @localkey, @keybits\n::First parameter is the encrypted text to decrypt.\n::Second parameter is plain text OUTPUT parameter with the result of decryption.\n::Third parameter is the password used to previously encrypt the master key.  If NULL is passed in, the current logged in user info is used to decrypt the key.\n::Fourth parameter is the encrypted master key.\n::The fifth parameter is the encrypted local key.\n::The sixth parameter is the number of bits to use in the key (128, 192 or 256).  NULL defaults to 256."
#define		USAGE_CELKO					"USAGE:  EXEC xp_phon_celko @text, @output OUTPUT\n::Parameter one is the text to encode.\n::Parameter two is the phonetic encoding result.\n"
#define		USAGE_DM					"USAGE:  EXEC xp_phon_dm @text.\n::Parameter is the string to phonetically encode.\n"
